#include <afxwin.h>
#include <struct.h>
#include <3dengine.h>
#include "Search.h"
#include "CPathDlg.h"
#include "resource.h"


IMPLEMENT_DYNAMIC( CMyCheckListBox, CCheckListBox )


BOOL CMyCheckListBox::Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID)
{

  NONCLIENTMETRICS metrics;
  metrics.cbSize = sizeof(NONCLIENTMETRICS);
  if (SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, (PVOID)&metrics, 0))
    font.CreateFontIndirect( &metrics.lfMenuFont);
  else
    font.CreateFont(  13, 0, 0, 0, FW_THIN,
              0, 0, 0, ANSI_CHARSET,
              OUT_DEFAULT_PRECIS,
              CLIP_DEFAULT_PRECIS,
              DEFAULT_QUALITY,
              DEFAULT_PITCH | FF_DONTCARE,
              "Arial Narrow");

  BOOL res = CCheckListBox::Create(dwStyle, rect, pParentWnd, nID);
  if (res)
    GetDC()->SelectObject(&font);
  return res;
}


BEGIN_MESSAGE_MAP(CPathsDialog, CPropertyPage)
  ON_COMMAND(IDC_ADD, OnAdd)
  ON_COMMAND(IDC_DELETE, OnDelete)
END_MESSAGE_MAP()


//////////////////////////////////////////////////////////////////////
//               Initialisation
//////////////////////////////////////////////////////////////////////
BOOL CPathsDialog::OnInitDialog()
{
  CRect r;
  GetDlgItem(IDC_STATICRECT)->GetClientRect(&r);
  r.left += 2;
  r.top += 2;
  r.right += 2;
  r.bottom += 2;
  List.Create(  LBS_HASSTRINGS |
          WS_CHILD |
          WS_VISIBLE |
          WS_VSCROLL,
          r,
          this,
          IDC_LIST);
  List.SetFont(&List.font);
  CWinApp* pApp = AfxGetApp();
  if (!pApp) return FALSE;
  
  CString folder = "Plugins settings\\z3dutils\\Textures Paths\\";

  int num = pApp->GetProfileInt(folder, "Amount", 0);
  CString  *Paths;
  Paths = new CString[num];
  CString  path;
  int ignored = 0;
  for (int i = 0; i < num - ignored; i++)
  {
    path = pApp->GetProfileString(folder, CString("Path")+Int2String(i));
    if (path == CString(""))
      ignored++;
    else
      Paths[i-ignored] = path;
  }
  for (i = 0; i < pD3D->Materials.Textures->PathsAmount; i++)
  {
    path = pD3D->Materials.Textures->GetPaths(i);
    List.AddString(path);
    List.SetCheck(i, 0);
    for (int j = 0; j < num-ignored; j++)
      if (Paths[j] == path)
        List.SetCheck(i, 1);
  }

  delete[] Paths;

  CurrentState.CurrentParams.sysp(
      Z3D_REQUEST_LOCALIZE_USER_DIALOG, NULL, "ZModeler\\Settings\\Paths Page", this, NULL);

  return TRUE;
}


afx_msg void CPathsDialog::OnAdd()
{
  CString str;
  CPathDlg diag(this, &str, "Choose Directory to add:");
  if (diag.DoModal() == IDOK)
    List.AddString(str);
}


afx_msg void CPathsDialog::OnDelete()
{
  List.DeleteString(List.GetCurSel());
  List.SetCurSel(0);
}


//////////////////////////////////////////////////////////////////////
//               Finalisation
//////////////////////////////////////////////////////////////////////
afx_msg void CPathsDialog::OnOK()
{
  CWinApp* pApp = AfxGetApp();
  if (!pApp) EndDialog(IDOK);
  
  CString folder = "Plugins settings\\z3dutils\\Textures Paths\\";
  CString path;
  int num = List.GetCount();
  int sel = 0;
  CurrentState.CurrentParams.pD3D->Materials.Textures->DeleteAllPaths();
  CurrentState.CurrentParams.pD3D->Materials.Textures->PathsAmount = 0L;
  for (int i = 0; i < num; i++)
  {
    List.GetText( i, path);
    CurrentState.CurrentParams.pD3D->Materials.Textures->AddPath(path.GetBuffer(path.GetLength()));
    if (List.GetCheck(i)==1)
    {
      pApp->WriteProfileString(folder, CString("Path")+Int2String(sel), path);
      sel++;
    }
  }
  pApp->WriteProfileInt(folder, "Amount", sel);
}



long nSearchPathsPageIndex = 0;


DWORD CALLBACK SearchPathsActivate(tProcParams* params)
{//Activate dialog box
  if (!params) return 0;
  if (!params->DllHandle || !params->AppHandle)
    return 0;

  params->sysp(Z3D_REQUEST_SHOWSETTINGSPAGE, NULL, NULL, &nSearchPathsPageIndex, NULL);

  return Z3D_PLUGRESULT_UPDATE;
}//Activate dialog box


DWORD CALLBACK SearchPathsReloader(tProcParams* params)
{
  CWinApp* pApp = AfxGetApp();
  if (!pApp || !params || !params->pD3D)
    return 0;

  CString folder = "Plugins settings\\z3dutils\\Textures Paths\\";
  CString path;

  int num = pApp->GetProfileInt(folder, "Amount", 0);
  if (num > 0)
    params->pD3D->Materials.Textures->DeleteAllPaths();

  for (int i = 0; i < num; i++)
  {
    path = pApp->GetProfileString(folder, CString("Path")+Int2String(i));
    if (path != CString(""))
      params->pD3D->Materials.Textures->AddPath(path.GetBuffer(path.GetLength()));
  }
  return Z3D_PLUGRESULT_ENABLEPROC;
}


DWORD CALLBACK SearchPathsOnLoad(tProcParams* params)
{//OnLoad...
  params->ListSet->SceneNew->AddProc("Search Paths Reloader",
    NULL,  //pre
    (PLUGPROCESSORPROC)SearchPathsReloader,//post
    (PLUGPROCESSORPROC)SearchPathsReloader,//onadd
    NULL, params, params->DllHandle);
  return Z3D_PLUGRESULT_ENABLEPROC;
}//Activate dialog box
